import pandas as pd   
import matplotlib.pyplot as plt
from decision_company import read_csv_file, get_fig_from_df, set_layout, create_subplots, show_plots, save_plot

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")
  
# Plot bar charts  
fig, axes = create_subplots(2, 2, figsize=(12, 8))  
  
get_fig_from_df(approval_rates_credit_history, kind='bar', ax=axes[0, 0], title='Approval Rates by Credit History')  
get_fig_from_df(approval_rates_employment, kind='bar', ax=axes[0, 1], title='Approval Rates by Employment Status')  
get_fig_from_df(approval_rates_middle_age, kind='bar', ax=axes[1, 0], title='Approval Rates for Middle-Age Group (40-59)')  
get_fig_from_df(approval_rates_credit_amount, kind='bar', ax=axes[1, 1], title='Approval Rates by Credit Amount Range')  
  
set_layout()  
save_plot('ref_result/bar_chart.png')  
show_plots() 
  